// UDataFile.cp
// UDataFile.h
// ----------------------------------------------------------------------------------
// File Buffer class for the Spell Checker project.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
// A file buffer is an abstract data class representing a file on disk.
// Internally it is stored as a linked list of 'pages' in the disk file.
// A user picks 'pages' to be read and can specify a header in the file
// that is ignored.
//
// Implementation Example
// 
// UBuffer is used by the spell checker to read in compressed pages from
// disk that hold the word list within a dictionary.  A header contains
// the location of the index, the number of words and other such data.
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original.  Simple read/write functions.
//		Clark Goble			08/11/94
//			Made the buffer into an abstract C++ class that was basically
//			an abstract datafile class.
//		Clark Goble			09/02/94
//			Made the buffer have a static linked list.  ie. one buffer for
//			all files.  Note: Write page doesn't check for correct file currently
// ----------------------------------------------------------------------------------

#include "Tspell.h"	// Speller Types and Constants
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Uio.h"

#ifndef _UDataFile_
#define _UDataFile_

// ----------------------------------------------------------------------------------
// Includes



// Use defines so that we have no globals
#define DIRTY  	0
#define CLEAN	1

// Size in bytes of a buffer
#define BUFFSIZE 2048



#endif

struct UBuffer {
	UInt8	CharBuffer[BUFFSIZE];
	UInt8	Dirty;		// has it been changed
	long 	BlockNum;
	UBuffer	*Next;		// next buffer
	Uio	*theFile;
};

class UDataFile {
public:
	UDataFile(Uio *theFile, long thePageSize, long theNumBuffers, long theOffset);
	~UDataFile();
	
	short 	ReadPage(long page, UInt8 *aBuffer);
	short	WritePage(long page, UInt8 *aBuffer);

	UBuffer	*NewBuffer(long page);
	UInt8 	*GetPage(long page);
	void		ClearBuffers();
protected:

private:
	Uio	*File;				// the physical file
	long	Offset;				// offset into the file

	UInt8	**TempBuffer;			// a temporary buffer
	long	*PageSize;			// size of the data file
	long	*BufferedPages;		// number of pages in buffers
	long	*MaxPages;			// possible number of buffers
	UBuffer	**FirstBuffer;		// the file's buffer

	// these are to replace statics
	UInt8	*sTempBuffer;
	long	sOffset;
	long	sPageSize;
	long	sBufferedPages;
	long	sMaxPages;
	UBuffer	*sFirstBuffer;
	short	sUses;

	short		*uses;

}; // UDataFile

